% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sampleped}
\alias{sampleped}
\title{Sampleped data}
\format{
A data frame with 55 observations, one line per subject, on the
following 7 variables.
\itemize{
\item \code{famid} : Family identifier
\item \code{id} : Subject identifier
\item \code{dadid} : Identifier of the father, if the father is part of the
data set; zero otherwise
\item \code{momid} : Identifier of the mother, if the mother is part of the
data set; zero otherwise
\item \code{sex} : \code{1} for male or \code{2} for female
\item \code{affection} : \code{1} or \code{0}
\item \code{avail} : \code{1} or \code{0}
\item \code{num} : Numerical test variable from 0 to 6 randomly distributed
}
}
\usage{
data("sampleped")
}
\description{
Small sample pedigree data set for testing purposes.
}
\details{
This is a small fictive pedigree data set, with 55
individuals in 2 families.
The aim was to create a data set with a variety of pedigree structures.
}
\examples{
data("sampleped")
pedi <- Pedigree(sampleped)
summary(pedi)
if (interactive()) { plot(pedi) }
}
\keyword{datasets}
