% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadPSet.R
\name{availablePSets}
\alias{availablePSets}
\title{Return a table of PharmacoSets available for download}
\usage{
availablePSets(canonical = TRUE)
}
\arguments{
\item{canonical}{\code{logical(1)} Should available PSets show only official
PSets, or should user generated PSets be included?}
}
\value{
A \code{data.frame} with details about the available PharmacoSet objects
}
\description{
The function fetches a table of all PharmacoSets available for download.
The table includes the dataset names, version information for the data in the PSet,
the date of last update, the name of the PSet, and references for the data contained within,
a DOI for the data, and a direct download link. Download can also be done using the downloadPSet
function.
}
\details{
Much more information on the processing of the data and data provenance can be found at:
www.orcestra.ca
}
\examples{
if (interactive()){
    availablePSets()
}

}
