% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-SignatureClass.R
\name{showSigAnnot,PharmacoSig-method}
\alias{showSigAnnot,PharmacoSig-method}
\title{Show the Annotations of a signature object}
\usage{
\S4method{showSigAnnot}{PharmacoSig}(object)
}
\arguments{
\item{object}{An object of the \code{PharmacoSig} Class, as
returned by \code{drugPerturbationSig} or \code{drugSensitivitySig}}
}
\value{
Prints the PharmacoGx Signatures annotations to the output stream, and returns invisible NULL.
}
\description{
This funtion prints out the information about the call used to compute the drug signatures, and the session info
for the session in which the computation was done. Useful for determining the exact conditions used to generate signatures.
}
\examples{
data(GDSCsmall)
drug.sensitivity <- drugSensitivitySig(GDSCsmall, mDataType="rna",
             nthread=1, features = fNames(GDSCsmall, "rna")[1])
showSigAnnot(drug.sensitivity)

}
