% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Impute.R
\name{tImpute}
\alias{tImpute}
\title{Tail-based impute}
\usage{
tImpute(mat, m, s, assay)
}
\arguments{
\item{mat}{a matrix (or PhosphoExperiment object) with rows correspond to 
phosphosites and columns correspond to samples.}

\item{m}{a numeric number for controlling mean downshifting.}

\item{s}{a numeric number for controlling standard deviation of downshifted
sampling values.}

\item{assay}{an assay to be selected if \code{mat} is a PhosphoExperiment 
object.}
}
\value{
An imputed matrix. If param \code{mat} is a SummarizedExperiment 
object, a SummarizedExperiment object will be returned.
}
\description{
Tail-based imputation approach as implemented in Perseus.
}
\examples{

data('phospho.cells.Ins.sample')
grps = gsub('_[0-9]{1}', '', colnames(phospho.cells.Ins))
phospho.cells.Ins.filtered <- selectGrps(phospho.cells.Ins, grps, 0.5, n=1)

set.seed(123)
phospho.cells.Ins.impute <- tImpute(phospho.cells.Ins.filtered)

# For PhosphoExperiment Object
data('phospho.cells.Ins.pe')
grps = gsub('_[0-9]{1}', '', colnames(phospho.cells.Ins.pe))
phospho.cells.Ins.filtered <- selectGrps(phospho.cells.Ins.pe, grps, 
    0.5, n=1)

set.seed(123)
phospho.cells.Ins.impute <- tImpute(phospho.cells.Ins.filtered)

}
