% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDomainPlot.R
\name{linearizeArchitecture}
\alias{linearizeArchitecture}
\title{Linearize PFAM/SMART annotations by best e-value/bitscore}
\usage{
linearizeArchitecture(domainDf = NULL, orthoID = NULL, value = "evalue")
}
\arguments{
\item{domainDf}{input domain dataframe}

\item{orthoID}{ID of protein that needs to be linearized}

\item{value}{type of values that will be used for linearized, either evalue
(default) or bitscore}
}
\value{
Domain dataframe of the selected protein after linearization
}
\description{
Linearize PFAM/SMART annotations by best e-value/bitscore
}
\examples{
demoDomainDf <- data.frame(
    orthoID = rep("protID", 4),
    start = c(1, 5, 100, 80),
    end = c(30, 40, 130, 110),
    evalue = c(0.001, 0.0005, 0.2, 0.004),
    feature_type = c(rep("pfam", 2), rep("smart", 2)),
    feature_id = c("pf1", "pf2", "sm1", "sm2")
)
linearizeArchitecture(demoDomainDf, "protID", "evalue")
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
