% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDomainPlot.R
\name{pairDomainPlotting}
\alias{pairDomainPlotting}
\title{Create architecure plot for a pair of seed and ortholog protein}
\usage{
pairDomainPlotting(seed, ortho, seedDf, orthoDf, minStart, maxEnd,
    labelSize, titleSize, legendSize, showScore, showWeight, namePosition, 
    firstDist, nameType, nameSize, segmentSize, nameColor, labelPos, 
    colorPalette, font)
}
\arguments{
\item{seed}{Seed ID}

\item{ortho}{Ortho ID}

\item{seedDf}{domain dataframe for seed domains containing the seed ID,
ortholog ID, sequence length, feature names, start and end positions,
feature weights (optional) and the status to determine if that feature is
important for comparison the architecture between 2 proteins* (e.g. seed
protein vs ortholog) (optional)}

\item{orthoDf}{domain dataframe for ortholog domains (same format as seedDf)}

\item{minStart}{the smallest start position of all domains}

\item{maxEnd}{the highest stop position of all domains}

\item{labelSize}{lable size. Default = 12}

\item{titleSize}{title size. Default = 12}

\item{legendSize}{legend size. Default = 12}

\item{showScore}{show/hide E-values and Bit-scores. Default = NULL (hide)}

\item{showWeight}{Show/hide feature weights. Default = NULL (hide)}

\item{namePosition}{list of positions for domain names, choose from "plot",
"legend" or "axis". Default: "plot"}

\item{firstDist}{distance of the first domain to plot title. Default = 0.5}

\item{nameType}{type of domain names, either "Texts" or "Labels" (default)}

\item{nameSize}{Size of domain names. Default = 3}

\item{segmentSize}{Height of domain segment. Default = 5}

\item{nameColor}{color of domain names (for Texts only). Default = "black"}

\item{labelPos}{position of domain names (for Labels only). Choose from
"Above" (default), "Below" or "Inside" the domain bar}

\item{colorPalette}{color pallete. Default = Paired"}

\item{font}{font of text. Default = Arial"}
}
\value{
Domain plot of a pair proteins as a arrangeGrob object.
}
\description{
Create architecure plot for a pair of seed and ortholog protein
}
\examples{
seed <- "101621at6656"
ortho <- "101621at6656|AGRPL@224129@0|224129_0:001955|1"
ortho <- gsub("\\\\|", ":", ortho)
grepID <- paste(seed, "#", ortho, sep = "")
domainFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
domainDf <- parseDomainInput(seed, domainFile, "file")
domainDf$feature_id_mod <- domainDf$feature_id
subdomainDf <- domainDf[grep(grepID, domainDf$seedID), ]
subdomainDf$feature <- as.character(subdomainDf$feature)
orthoDf <- subdomainDf[subdomainDf$orthoID == ortho,]
seedDf <- subdomainDf[subdomainDf$orthoID != ortho,]
minStart <- min(subdomainDf$start)
maxEnd <- max(c(subdomainDf$end, subdomainDf$length))
# resolve overlapping domains
seedDf <- PhyloProfile:::resolveOverlapFeatures(seedDf)
orthoDf <- PhyloProfile:::resolveOverlapFeatures(orthoDf)
# add feature colors
featureColorDf <- PhyloProfile:::addFeatureColors(seedDf, orthoDf)
seedDf <- featureColorDf[[1]]
orthoDf <- featureColorDf[[2]]
# do plot
g <- PhyloProfile:::pairDomainPlotting(
   seed,ortho,seedDf,orthoDf,minStart,maxEnd, font = "sans"
)
grid::grid.draw(g)
}
\seealso{
\code{\link{singleDomainPlotting}}, \code{\link{sortDomains}},
\code{\link{parseDomainInput}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
