% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_analysis.R
\name{findEnrichedFunctions}
\alias{findEnrichedFunctions}
\title{findEnrichedFunctions}
\usage{
findEnrichedFunctions(targetGenes, species, ...)
}
\arguments{
\item{targetGenes}{Vector of Ensembl gene ids or gene names}

\item{species}{First letter of genus + species name: e.g. hsapiens}

\item{...}{Other arguments to be passed to gprofiler2::gost}
}
\description{
Find enriched functional terms among the genes that overlap
the regions of interest.
}
\details{
This function is basically a call to gprofiler2::gost function. 
It is here to serve as a replacement for other deprecated functional
enrichment functions.
}
\examples{
data(gff)
data(queryRegions)

overlaps <- queryGff(queryRegions, gff)
res <- findEnrichedFunctions(unique(overlaps$gene_id), 'hsapiens')

}
