% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{PlotTrajectory}
\alias{PlotTrajectory}
\title{Infer the developmental trajectories based on the clustering results from RCSL}
\usage{
PlotTrajectory(
  gfData,
  clustRes,
  TrueLabel,
  lineage,
  fontSize = 12,
  dataName = "",
  VisualMethod = "umap"
)
}
\arguments{
\item{gfData}{preprocessed gene expression data (each column represent a cell)}

\item{clustRes}{the clustering results identified by RCSL}

\item{TrueLabel}{the real cell types}

\item{lineage}{the lineage obtained by getLineage()}

\item{fontSize}{the size of font in the plot}

\item{dataName}{the name of the data that will be showed in the plot}

\item{VisualMethod}{the display method of 2-D visualization}
}
\value{
TrajectoryPlot ggplot object of the inferred developmental trajectories
}
\description{
Infer the developmental trajectories based on the clustering results from RCSL
}
\examples{
gfData <- GenesFilter(yan)
TrueLabel <- ann$cell_type1
res_SimS <- SimS(gfData)
C <- EstClusters(res_SimS$drData,res_SimS$S)
res_BDSM <- BDSM(res_SimS$S,C)
Pseudo <- PlotPseudoTime(res_SimS$S,TrueLabel,startPoint=1)
Linea <- getLineage(res_SimS$drData,res_BDSM$y,Pseudo$pseudoTime)
PlotTrajectory(gfData,res_BDSM$y,TrueLabel,lineage=Linea)

}
