% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-NodesAndEdges.R
\name{Nodes}
\alias{Nodes}
\alias{createNodes}
\title{Nodes}
\usage{
createNodes(id = NULL, name = NULL, represents = NULL)
}
\arguments{
\item{id}{integer (optional); node IDs}

\item{name}{character (optional); names of the nodes}

\item{represents}{character (optional); representation, e.g. a link to another database}
}
\value{
\emph{NodesAspect} object
}
\description{
This function creates nodes for networks.
}
\details{
Nodes are represented by \emph{NodesAspect} objects.
A single node is defined by its unique \emph{id}, which must be an (positive) integer, which serves as reference to other aspects.
Optionally, nodes can have a name and a represents attribute.
If no IDs are provided, but either names or representations (or both) IDs are assigned automatically.
To be valid, a nodes aspect must contain at least one node.
However, if no parameters are set (i.e. \emph{id}, \emph{name} and \emph{represents} = \code{NULL}) there is still one node created with neither name nor representation,
just an ID.
The \emph{NodesAspect} is the only mandatory aspect for an \code{\link{RCX-object}}.
}
\examples{
## a minimal example
nodes = createNodes()

## ids will be generated
nodes = createNodes(name = c("a","b","c"))

## with all parameters
nodes = createNodes(id=c(1, 2, 3), 
                    name=c("CDK1", "CDK2", "CDK3"),
                    represents=c("HGNC:CDK1", 
                                 "Uniprot:P24941", 
                                 "Ensembl:ENSG00000250506"))
}
\seealso{
\code{\link{updateNodes}}, \code{\link{RCX-object}}
}
