% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Json-toJson.R
\name{toCX}
\alias{toCX}
\title{Convert an \link[=RCX-object]{RCX} object to CX (JSON)}
\usage{
toCX(rcx, verbose = FALSE, pretty = FALSE)
}
\arguments{
\item{rcx}{\link[=RCX-object]{RCX} object}

\item{verbose}{logical; whether to print what is happening}

\item{pretty}{logical; adds indentation whitespace to JSON output.
Can be TRUE/FALSE or a number specifying the number of spaces to indent. See \code{\link[jsonlite:prettify]{jsonlite::prettify()}}}
}
\value{
CX (JSON) text
}
\description{
This function converts an \link[=RCX-object]{RCX} object to JSON in a valid CX data structure
(see NDEx documentation: \url{https://home.ndexbio.org/data-model/}).
}
\details{
The single aspects of the \link[=RCX-object]{RCX} object are processed by generic functions of \link{rcxToJson} for each aspect class.
Therefore, not only the single aspects are converted to JSON, but also necessary additional aspects are added,
so the resulting CX is accepted by the NDEx platform (\url{https://ndexbio.org/}):
\itemize{
\item \emph{numberVerication} shows the supported maximal number
\item \emph{status} is needed at the end to show, that no errors have occurred while creation
}

If the \link[=RCX-object]{RCX} object contains additional aspects besides the officially defined ones,
the corresponding \link{rcxToJson} functions for those aspect classes have to be implemented in order to include
them in the resulting CX.
}
\examples{
rcx = createRCX(
  nodes = createNodes(
    name = LETTERS[seq_len(10)]
  ),
  edges = createEdges(
    source=c(1,2),
    target = c(2,3)
  )
)

json = toCX(rcx, pretty=TRUE)
}
\seealso{
\link{toCX}, \link{rcxToJson}, \link{readCX}, \link{writeCX}
}
