% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_enrichment.R
\name{plot.term_enrichment_by_subset}
\alias{plot.term_enrichment_by_subset}
\title{plot.term_enrichment_by_subset}
\usage{
\method{plot}{term_enrichment_by_subset}(
  x,
  show_values = TRUE,
  annotation_matrix = NA,
  low = "white",
  high = "#2166AC",
  return_ggplot_object = FALSE,
  label_size_x = 16,
  label_angle_x = -30,
  label_size_y = 9,
  wrap_y_labels = 20,
  grid_line_color = "white",
  mid = 0,
  cap = NA,
  annotation_palates = c("Reds", "Greens", "Purples", "Greys", "BuPu", "RdPu", "BrBG",
    "PiYG", "Spectral"),
  annotation_legend_x = -0.3,
  trim_resource_names = TRUE,
  ...
)
}
\arguments{
\item{x}{data frame returned by term_enrichment_by_subset}

\item{show_values}{True or False, plot values on the heatmap}

\item{annotation_matrix}{a matrix() of group-levle characteristics - same number of columns as "m"}

\item{low}{color for low end of range}

\item{high}{color for high end of range}

\item{return_ggplot_object}{logical flag (default FALSE) that if TRUE, the ggplot object for the plot is returned}

\item{label_size_x}{size of text for x label. Default lable_size_x=16}

\item{label_angle_x}{angle for text for x label. Default is -30 degrees}

\item{label_size_y}{size of text for y label. Default label_size_y=9}

\item{wrap_y_labels}{Number of characters to wrap row labels}

\item{grid_line_color}{color o grid lines between cells. Default is white.}

\item{mid}{sets lower threshold for color scale}

\item{cap}{Clip numeric values to this maximum threshold}

\item{annotation_palates}{Color palates (RColorBrewer) used for each row of the annotation matrix}

\item{annotation_legend_x}{offset for placing the legend}

\item{trim_resource_names}{[TRUE] remove any text in rownames preceeding a period characte. This convension is usually used in RITAN to prepend the resource name to the term name, which may not be needed in plotting.}

\item{...}{further areguments are not used at this time. If the user wants to modify the plot, use return_ggplot_object = TRUE.}
}
\value{
silent return, unless return_ggplot_object==TRUE. Then, the ggplot object for the plot is returned.
}
\description{
plot.term_enrichment_by_subset
}
\examples{
## Create list of gene sets to evaluate.
##   This example is from a vaccine study where we pre-generated differentially expressed genes.
##   This object will be passed to the groups parameter.
require(RITANdata)
vac1.de.genes <- list(vac1.day0vs31.de.genes, vac1.day0vs56.de.genes)
names(vac1.de.genes) <- c("Day0vs31", "Day0vs56")
print(str(vac1.de.genes))

\dontrun{
## Run term_enrichment_by_subset on the two results.
##   This function usually takes a few seconds to a minute to run.
m <- term_enrichment_by_subset(groups = vac1.de.genes, q_value_threshold = .9)
summary(m)
plot( m, label_size_y = 4, show_values = FALSE )
}

}
