% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcRIVER.R
\name{getFuncRvPosteriors}
\alias{getFuncRvPosteriors}
\title{Posterior probabilities of FR given G and E.}
\usage{
getFuncRvPosteriors(Out, probFuncRvFeat, theta)
}
\arguments{
\item{Out}{Binary values of outlier status (E).}

\item{probFuncRvFeat}{probabilities of FR given genomic features and estimated
beta, P(FR | G, beta), from \code{getFuncRvFeat}.}

\item{theta}{Current estimate of theta.}
}
\value{
posterior probabilities of FR (P(FR | G, E, beta, theta)) and probable
        status of FR.
}
\description{
\code{getFuncRvPosteriors} computes posterior probabilities of functionality
        of regulatory variant (FR) given genomic features (G) and outlier
        status (E) with current estimate of beta (parameters between FR and G)
        and theta (parameters between FR and E).
}
\examples{
dataInput <- getData(filename=system.file("extdata", "simulation_RIVER.gz",
        package = "RIVER"), ZscoreThrd=1.5)
Feat <- scale(t(Biobase::exprs(dataInput))) # genomic features (G)
Out <- as.vector(as.numeric(unlist(dataInput$Outlier))-1) # outlier status (E)
theta.init<-matrix(c(.99, .01, .3, .7), nrow=2)
costs<-c(100, 10, 1, .1, .01, 1e-3, 1e-4)
logisticAllCV <- glmnet::cv.glmnet(Feat, Out, lambda=costs, family="binomial",
        alpha=0, nfolds=10)
probFuncRvFeat <- getFuncRvFeat(Feat, logisticAllCV$glmnet.fit,
        logisticAllCV$lambda.min)
posteriors <- getFuncRvPosteriors(Out, probFuncRvFeat, theta=theta.init)

}
\author{
Yungil Kim, \email{ipw012@gmail.com}
}
