% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJMCMCNucleosomes.R
\docType{data}
\name{RJMCMC_result}
\alias{RJMCMC_result}
\title{Nucleosomes obtained by running RJMCMC function using reads
from reads_demo_02 dataset (for demo purpose).}
\format{A \code{list} of \code{class} "rjmcmcNucleosomes" containing:
\itemize{
\item \code{call} the matched call.
\item \code{k} a \code{integer}, the final estimation of the number
of nucleosomes. \code{0} when no nucleosome is detected.
\item \code{mu} a \code{vector} of \code{numeric} of length
\code{k}, the positions of the nucleosomes. \code{NA} when no nucleosome is
detected.
\item \code{k_max} a \code{integer}, the maximum number of nucleosomes
obtained during the iteration process. \code{NA} when no nucleosome is
detected.
}}
\usage{
data(RJMCMC_result)
}
\value{
A \code{list} of \code{class} "rjmcmcNucleosomes" containing:
\itemize{
\item \code{call} the matched call.
\item \code{k} a \code{integer}, the final estimation of the number
of nucleosomes. \code{0} when no nucleosome is detected.
\item \code{mu} a \code{vector} of \code{numeric} of length
\code{k}, the positions of the nucleosomes. \code{NA} when no nucleosome is
detected.
\item \code{k_max} a \code{integer}, the maximum number of nucleosomes
obtained during the iteration process. \code{NA} when no nucleosome is
detected.
}
}
\description{
A \code{list} of \code{class}
"rjmcmcNucleosomes" which contains the information about the
detected nucleosomes.
}
\examples{

## Loading dataset
data(RJMCMC_result)
data(reads_demo_02)

## Results before post-treatment
RJMCMC_result$mu

## Post-treatment function which merged closely positioned nucleosomes
postResult <- postTreatment(reads = reads_demo_02,
    extendingSize = 60, chrLength = 100000, resultRJMCMC = RJMCMC_result)

## Results after post-treatment
postResult

}
\seealso{
\itemize{
    \item \code{\link{rjmcmc}} {for profiling of nucleosome positions}
    \item \code{\link{rjmcmcCHR}} { for profiling of nucleosome positions
    for a large region. The function will take care of spliting and
    merging.}
    \item \code{\link{segmentation}} { for spliting a \code{GRanges}
    containing reads in a list of smaller segments for
    the \code{rjmcmc} function.}
    \item \code{\link{postTreatment}} { for merging closely positioned
    nucleosomes}
    \item \code{\link{mergeRDSFiles}} { for merging nucleosome information
    from selected RDS files.}
    \item \code{\link{plotNucleosomes}} { for generating a graph containing
    the nucleosome positions and the read coverage.}
}
}
\keyword{datasets}
