% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SequenceData-stats.R
\name{stats}
\alias{stats}
\alias{stats,SequenceData,BamFile-method}
\alias{stats,SequenceData,BamFileList-method}
\alias{stats,Modifier,missing-method}
\alias{stats,ModifierSet,missing-method}
\title{Retrieving information about used reads in RNAmodR}
\usage{
stats(x, file, ...)

\S4method{stats}{SequenceData,BamFile}(x, file, ...)

\S4method{stats}{SequenceData,BamFileList}(x, file, ...)

\S4method{stats}{Modifier,missing}(x)

\S4method{stats}{ModifierSet,missing}(x)
}
\arguments{
\item{x}{a \code{\link[=SequenceData-class]{SequenceData}}, 
\code{\link[=Modifier-class]{Modifier}} or 
\code{\link[=ModifierSet-class]{ModifierSet}} object}

\item{file}{a \code{\link[Rsamtools:BamFile-class]{BamFile}} or 
\code{\link[Rsamtools:BamFile-class]{BamFileList}}, if \code{x} is a 
\code{\link[=SequenceData-class]{SequenceData}} object.}

\item{...}{optional parameters used as stated 
\code{\link[=SequenceData-class]{here}} (except \code{minQuality}),
if \code{x} is a \code{\link[=SequenceData-class]{SequenceData}} object.}
}
\value{
a \code{DataFrame}, \code{DataFrameList} or \code{SimpleList} with 
  the results in aggregated form
}
\description{
\code{stats} returns information about reads used in the RNAmodR analysis.
Three modes are available depending on which type of object is provided. If a
\code{\link[=SequenceData-class]{SequenceData}} object is provided, a
\code{\link[Rsamtools:BamFile-class]{BamFile}} or
\code{\link[Rsamtools:BamFile-class]{BamFileList}} must be provided as well. If a
\code{\link[=Modifier-class]{Modifier}} object is used, the bam files
returned from the \code{bamfiles} function are used. This is also the case,
if a \code{\link[=ModifierSet-class]{ModifierSet}} object is used.
}
\examples{
library(RNAmodR.Data)
library(rtracklayer)
sequences <- RNAmodR.Data.example.AAS.fasta()
annotation <- GFF3File(RNAmodR.Data.example.AAS.gff3())
files <- list("SampleSet1" = c(treated = RNAmodR.Data.example.wt.1(),
                               treated = RNAmodR.Data.example.wt.2(),
                               treated = RNAmodR.Data.example.wt.3()),
              "SampleSet2" = c(treated = RNAmodR.Data.example.bud23.1(),
                               treated = RNAmodR.Data.example.bud23.2()),
              "SampleSet3" = c(treated = RNAmodR.Data.example.trm8.1(),
                               treated = RNAmodR.Data.example.trm8.2()))
msi <- ModSetInosine(files, annotation = annotation, sequences = sequences)
# smallest chunk of information
stats(sequenceData(msi[[1L]]),bamfiles(msi[[1L]])[[1L]])
# partial information
stats(sequenceData(msi[[1L]]),bamfiles(msi[[1L]]))
# the whole stats
stats(msi)
}
