% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pDisExpress.R
\name{pDis}
\alias{pDis}
\title{Primary dis-regulation: Pathway analysis approach based on the unexplained dis-regulation of genes}
\usage{
pDis(x, graphs, ref = NULL, nboot = 2000, verbose = TRUE,
  cluster = NULL, seed = NULL)
}
\arguments{
\item{x}{named vector of log fold changes for the differentially expressed genes; \code{names(x)} must use the same id's as \code{ref} and the nodes of the \code{graphs}}

\item{graphs}{list of pathway graphs as objects of type \code{graph} (e.g., \code{\link{graphNEL}}); the graphs must be weighted graphs (i.e., have an attribute \code{weight} for both nodes and edges)}

\item{ref}{the reference vector for all genes in the analysis; if the reference is not provided or it is identical to \code{names(x)} a cut-off free analysis is performed}

\item{nboot}{number of bootstrap iterations}

\item{verbose}{print progress output}

\item{cluster}{a cluster object created by makeCluster for parallel computations}

\item{seed}{an integer value passed to set.seed() during the boostrap permutations}
}
\value{
An object of class \code{\link{pDisRes-class}}.
}
\description{
Primary dis-regulation: Pathway analysis approach based on the unexplained dis-regulation of genes
}
\details{
See details in the cited articles.
}
\examples{

# load a multiple sclerosis study (public data available in Array Express 
# ID: E-GEOD-21942)
# This file contains the top table, produced by the limma package with 
# added gene information. All the probe sets with no gene associate to them,
# have been removed. Only the most significant probe set for each gene has been
# kept (the table is already ordered by p-value)
# The table contains the expression fold change and signficance of each  
# probe set in peripheral blood mononuclear cells (PBMC) from 12 MS patients
# and 15 controls.
load(system.file("extdata/E-GEOD-21942.topTable.RData", package = "ROntoTools"))
head(top)

# select differentially expressed genes at 1\% and save their fold change in a 
# vector fc and their p-values in a vector pv
fc <- top$logFC[top$adj.P.Val <= .01]
names(fc) <- top$entrez[top$adj.P.Val <= .01]

pv <- top$P.Value[top$adj.P.Val <= .01]
names(pv) <- top$entrez[top$adj.P.Val <= .01]

# alternativly use all the genes for the analysis
# NOT RUN: 
# fc <- top$logFC
# names(fc) <- top$entrez

# pv <- top$P.Value
# names(pv) <- top$entrez

# get the reference
ref <- top$entrez

# load the set of pathways
kpg <- keggPathwayGraphs("hsa")

# set the beta information (see the citated documents for meaning of beta)
kpg <- setEdgeWeights(kpg)

# inlcude the significance information in the analysis (see Voichita:2012 
# for more information)
# set the alpha information based on the pv with one of the predefined methods
kpg <- setNodeWeights(kpg, weights = alphaMLG(pv), defaultWeight = 1)

# perform the pathway analysis
# in order to obtain accurate results the number of boostraps, nboot, should 
# be increase to a number like 2000
pDisRes <- pDis(fc, graphs = kpg, ref = ref, nboot = 100, verbose = TRUE)

# obtain summary of results
head(Summary(pDisRes))

}
\author{
Calin Voichita, Sahar Ansari and Sorin Draghici
}
\references{
Voichita C., Donato M., Draghici S.: "Incorporating gene significance in the impact analysis of signaling pathways", IEEE Machine Learning and Applications (ICMLA), 2012 11th International Conference on, Vol. 1, p.126-131, 2012
Ansari, S., Voichita, C., Donato, M., Tagett, R., & Draghici, S. A Novel Pathway Analysis Approach Based on the Unexplained Disregulation of Genes.
}
\seealso{
\code{\link{Summary}}, 
\code{\link{keggPathwayGraphs}}, \code{\link{setNodeWeights}}, \code{\link{setEdgeWeights}}
}

