% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkTCGA.R
\name{checkTCGA}
\alias{checkTCGA}
\title{Information About Datasets from TCGA Project}
\usage{
checkTCGA(what, cancerType, date = NULL)
}
\arguments{
\item{what}{One of \code{DataSets} or \code{Dates}.}

\item{cancerType}{A character of length 1 containing abbreviation (Cohort code - \href{https://gdac.broadinstitute.org/}{https://gdac.broadinstitute.org/})
of types of cancers to check for.}

\item{date}{A \code{NULL} or character specifying from which date informations should be checked.
By default (\code{date = NULL}) the newest available date is used. All available dates can be checked on 
\href{https://gdac.broadinstitute.org/runs/}{https://gdac.broadinstitute.org/runs/} or by using \code{checkTCGA('Dates')} 
function. Required format \code{'YYYY-MM-DD'}.}
}
\value{
\itemize{
     \item If \code{what='DataSets'} a data.frame of available datasets' names (to pass to the \link{downloadTCGA} function) and sizes.
     \item If \code{what='Dates'} a vector of available dates to pass to the \link{downloadTCGA} function.
     }
}
\description{
The \code{checkTCGA} function let's to check
 
\itemize{
     \item \code{DataSets}: TCGA datasets' names for current release date and cohort.
     \item \code{Dates}: TCGA datasets' dates of release.
 }
}
\details{
\itemize{
     \item If \code{what='DataSets'} enables to check TCGA datasets' names for current release date and cohort.
     \item If \code{what='Dates'} enables to check dates of TCGA datasets' releases.
     }
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{

############################# 

# names for current release date and cohort
checkTCGA('DataSets', 'BRCA')
\dontrun{
checkTCGA('DataSets', 'OV', tail(checkTCGA('Dates'))[3])
#checkTCGA('DataSets', 'OV', checkTCGA('Dates')[5]) # error
}
# dates of TCGA datasets' releases.
checkTCGA('Dates')

############################# 
\dontrun{
# TCGA datasets' names availability for 
# current release date and cancer type.

releaseDate <- '2015-08-21'
cancerTypes <- c('OV', 'BRCA')

cancerTypes \%>\% sapply(function(element){
  grep(x = checkTCGA('DataSets', element, releaseDate)[, 1], 
      pattern = 'humanmethylation450', value = TRUE) \%>\%
       as.vector()
       })
       
}
}
\seealso{
\pkg{RTCGA} website \href{https://rtcga.github.io/RTCGA/}{https://rtcga.github.io/RTCGA/}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
