% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree-methods.R
\docType{methods}
\name{ComputeKinshipPropCoef}
\alias{ComputeKinshipPropCoef}
\alias{ComputeKinshipPropCoef,pedigree-method}
\alias{ComputeKinshipPropCeof}
\title{ratio of excess kinship among descendants over mean kinship among
founders}
\usage{
ComputeKinshipPropCoef(ped)

\S4method{ComputeKinshipPropCoef}{pedigree}(ped)
}
\arguments{
\item{ped}{pedigree object (S3)}
}
\value{
a symmetric matrix of ratios for all pair of final descendants
in the pedigree structure contained in the pedigree
}
\description{
Computes, for each pair of final descendants in the
pedigree structure contained in the pedigree object, the ratio of
the difference between the inferred and expected kinship coefficient
for the pair over the mean kinship among founders.
}
\details{
The ratio for each pair of final descendants is computed
using equation (A1) of Bureau et al. Dividing the difference between
the inferred and expected kinship coefficient for each pair by this ratio
gives a pair-specific estimate of the mean kinship among founders, which
can then be averaged over all pairs of final descendants from the same
population to obtain a global estimate of the mean kinship among founders.
}
\examples{
data(samplePedigrees)
ComputeKinshipPropCoef(samplePedigrees$firstCousinTriple)
}
\references{
Bureau, A., Younkin, S., Parker, M.M., Bailey-Wilson, J.E.,
Marazita, M.L., Murray, J.C., Mangold, E., Albacha-Hejazi, H., Beaty, T.H.
and Ruczinski, I. (2014) Inferring rare disease risk variants based on
exact probabilities of sharing by multiple affected relatives.
Bioinformatics, 30(15): 2189-96, doi:10.1093/bioinformatics/btu198.
}
