% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwa_sam.R
\name{bwa_sam}
\alias{bwa_sam}
\title{R wrapper to convert bwa aln output to SAM format}
\usage{
bwa_sam(
  type = c("single", "paired"),
  index_prefix,
  fastq_files,
  sai_files,
  sam_file,
  ...
)
}
\arguments{
\item{type}{String specifying type of reads:
"single" for single-end reads (default) or
"paired" for paired-end reads.}

\item{index_prefix}{String specifying prefix of the BWA index.}

\item{fastq_files}{Character vector specifying paths of fastq files.
If \code{type=="single"}, must be of length 1.
If \code{type=="paired"}, must be of length 2.}

\item{sai_files}{Character vector specifying filenames of the \code{bwa aln}
aligmment output files.
If \code{type=="single"}, must be of length 1.
If \code{type=="paired"}, must be of length 2.}

\item{sam_file}{String specifying paths of the SAM output file.}

\item{...}{Other arguments to pass to \code{bwa_sam}.}
}
\value{
No return value. Output SAM files are
    produced as side effect.
}
\description{
R wrapper to convert bwa aln output to SAM format.
}
\examples{
# Creating index:
dir <- tempdir()
fasta <- system.file(package="Rbwa",
                     "fasta/chr12.fa")
fastq <- system.file(package="Rbwa",
                     "fastq/sequences.fastq")
index_prefix <- file.path(dir,"chr12")
bwa_build_index(fasta, index_prefix=index_prefix)

# Creating alignments:
bwa_aln(index_prefix=index_prefix,
        fastq_files=fastq,
        sai_files=file.path(dir, "output.sai"))

# Generating SAM file:
bwa_sam(index_prefix=index_prefix,
        fastq_files=fastq,
        sai_files=file.path(dir, "output.sai"),
        sam_file=file.path(dir, "output.sam"))

# Reading in alignments from SAM file:
aln <- readLines(file.path(dir, "output.sam"))
aln

}
\author{
Jean-Philippe Fortin
}
