% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipeLoad.R
\name{recipeLoad}
\alias{recipeLoad}
\title{recipeLoad}
\usage{
recipeLoad(
  rcp = c(),
  cachePath = "ReUseDataRecipe",
  env = .GlobalEnv,
  return = TRUE
)
}
\arguments{
\item{rcp}{The (vector of) character string of recipe name or file
path (\code{recipeNames()} or \code{mcols()$fpath} column of the
\code{recipeHub} object returned from \code{recipeSearch}).}

\item{cachePath}{A character string for the recipe cache. Must
match the one specified in \code{recipeUpdate()}. Default is
"ReUseDataRecipe".}

\item{env}{The R environment to export to. Default is \code{.GlobalEnv}.}

\item{return}{Whether to return the recipe to a user-assigned R
object. Default is TRUE, where user need to assign a variable
name to the recipe. e.g., \code{rcp1 <- recipeLoad()}. If FALSE, it
loads the recipe and uses its original name, and user doesn't
need to assign a new name. e.g., \code{recipeLoad(return=TRUE)}. If
multiple recipes are to be loaded, \code{return=FALSE} must be used.}
}
\value{
A data recipe of \code{cwlProcess} S4 class, which is ready to
be evaluated in \emph{R}.
}
\description{
To load data recipe(s) into R environment.
}
\examples{
########################
## Load single recipe
########################

library(Rcwl)
recipeUpdate()
recipeSearch("liftover")
rcp <- recipeLoad("ensembl_liftover")
Rcwl::inputs(rcp)
rm(rcp)

gencode_annotation <- recipeLoad("gencode_annotation")
inputs(gencode_annotation)
rm(gencode_annotation)

#########################
## Load multiple recipes
#########################

rcphub <- recipeSearch("gencode")
recipeNames(rcphub)
recipeLoad(recipeNames(rcphub), return=FALSE)
inputs(gencode_transcripts)
}
