% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_request.R
\name{ReactomeAnalysisRequest}
\alias{ReactomeAnalysisRequest}
\title{ReactomeAnalysisRequest class}
\usage{
ReactomeAnalysisRequest(method)

ReactomeAnalysisRequest(method)
}
\arguments{
\item{method}{character. Name of the method to use.}
}
\value{
A ReactomeAnalysisRequest object.
}
\description{
This class is used to collect all information required to submit an
analysis request to the Reactome Analysis System.
}
\section{Slots}{

\describe{
\item{\code{method}}{character. Name of the method to use}

\item{\code{request_object}}{list. This slot should not be set manually. It stores the internal
request representation and should be modified using the classes' functions.
To add parameters, use \code{\link{set_parameters,ReactomeAnalysisRequest-method}}}
}}

\examples{
library(ReactomeGSA.data)
library(methods)

# create the request method and specify its method
request <- ReactomeAnalysisRequest(method = "Camera")

# add a dataset to the request
data(griss_melanoma_proteomics)

request <- add_dataset(request = request,
             expression_values = griss_melanoma_proteomics,
             name = "Proteomics",
             type = "proteomics_int",
             comparison_factor = "condition",
             comparison_group_1 = "MOCK",
             comparison_group_2 = "MCM",
             additional_factors = c("cell.type", "patient.id"))

# to launch the actual analysis use the perform_reactome_analysis function
}
