% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedNestMethods.R
\docType{methods}
\name{mergeOutEdges,numeric_Or_missing-method}
\alias{mergeOutEdges,numeric_Or_missing-method}
\alias{mergeOutEdges}
\title{mergeOutEdges}
\usage{
\S4method{mergeOutEdges}{numeric_Or_missing}(nlevels = 2, rescale = TRUE, lb = NA, ub = NA, rdp = NA)
}
\arguments{
\item{nlevels}{Number of levels (>=1) to be merged in the nested network.}

\item{rescale}{Logical value, whether to rescale out-edge width to not
overextend the container size; if 'FALSE', it will run a simple sum when
combining the out-edges.}

\item{lb}{Custom lower bound to rescale edge width between containers.}

\item{ub}{Custom upper bound to rescale edge width between containers.}

\item{rdp}{A \code{RedPort}-class object used by internal calls (ignore).}
}
\value{
Add/change edge assigments.
}
\description{
Method to assign out-edges to containers in an active
RedeR session. This method transfers edges from nodes to the respective
containers.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

# create a fully connected graph
g <- igraph::make_full_graph(5)
V(g)$name <- paste0("n", 1:5)

\donttest{
# Start the RedeR interface
startRedeR()

# Add 'g' to the interface
addGraphToRedeR(g, layout.kamada.kawai(g))

# Nest nodes in the interface
nestNodes(c("n1", "n2", "n3"), gcoord = c(30, 30), gscale = 30)
nestNodes(c("n4", "n5"), gcoord = c(70, 70), gscale = 20)

# Merge nodes between containers
mergeOutEdges()
}

}
\seealso{
\code{\link{addGraphToRedeR}}, \code{\link{getGraphFromRedeR}}.
}
\author{
Sysbiolab.
}
