% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedAttributeSeters.R
\name{transform.attributes}
\alias{transform.attributes}
\alias{att.addv}
\alias{att.adde}
\alias{att.setv}
\alias{att.sete}
\alias{att.mapv}
\title{Transforming edge and vertex attributes}
\usage{
att.addv(g, to, value, index = V(g), filter = NULL)

att.adde(g, to, value, index = E(g))

att.setv(
  g,
  from = "name",
  to = "nodeColor",
  pal = 1,
  cols = NULL,
  na.col = "grey70",
  xlim = c(20, 100, 1),
  breaks = NULL,
  nquant = NULL,
  digits = 1,
  title = from,
  isrev = FALSE
)

att.sete(
  g,
  from = "name",
  to = "edgeColor",
  pal = 1,
  cols = NULL,
  na.col = "grey70",
  xlim = c(20, 100, 1),
  breaks = NULL,
  nquant = NULL,
  title = from,
  digits = 1,
  isrev = FALSE
)

att.mapv(g, dat, refcol = 1)
}
\arguments{
\item{g}{An 'igraph' object.}

\item{to}{A valid RedeR attribute name (see \code{\link{addGraph}} or
type 'att.setv()' and 'att.sete()' for a quick list).}

\item{value}{A single value for an edge or vertex attribute.}

\item{index}{An optional index to set an attribute to a subset of vertices
or edges.}

\item{filter}{A named list of length = 1, used to filter which nodes will
receive the attribute. The attribute 'to' will be added to nodes which
have the attribute.}

\item{from}{An attribute name available in 'g'.}

\item{pal}{Color palette option (1 or 2); 'pal=1' will use a single color
palette, while 'pal=2' will split 'breaks' at the center, generating two
color palettes. The 'pal=2' option may be useful to build separated color
palettes, for example, negative and positive values.}

\item{cols}{Vector of colors (either hexadecimals or valid color names).}

\item{na.col}{A single color for NAs.}

\item{xlim}{A numeric vector with three boundaries:
c(<lower>, <upper>, <NA>). It corresponds to boundary values to be apply
to numeric attributes (e.g. nodeSize). Default: c(20, 100, 1).}

\item{breaks}{A numeric vector of two or more breakpoints to be applied
to the attribute values.}

\item{nquant}{Number of breakpoints to split attribute values by quantiles.}

\item{digits}{Integer indicating the number of decimal places in the
legend of numerical attributes.}

\item{title}{A legend title.}

\item{isrev}{A logical value, whether to verse attribute values.}

\item{dat}{A data frame with the attributes to be mapped to 'g'.}

\item{refcol}{A reference column in the 'dat' object used to map 'dat'
to 'g'. For 'att.mapv', 'refcol' is a single integer value indicating a
column with node ids. For 'att.mape', 'refcol' is a vector with two integers
indicating columns with edge ids. Also, for 'att.mapv', when 'refcol = 0'
rownames will be used to map 'dat' to 'g'.}
}
\value{
Add, map, and set igraph attributes to the RedeR application.
}
\description{
Given an 'igraph' object, 'att.addv' adds a new attribute with a fixed
'value' to all nodes or selected nodes, while 'att.adde' adds a new
attribute with a fixed 'value' to all edges.

The 'att.mapv' and 'att.mape' functions map data frames to an
'igraph' object.

The 'att.setv' and 'att.sete' functions rename attributes available in
the an 'igraph' object, transforming them into new attribute classes
(for example, numeric values into colors or sizes).
}
\examples{
library(igraph)

# Generate a 'toy' graph with vertex names
gtoy <- sample_pa(10, directed=FALSE)
V(gtoy)$name <- paste0("V",1:vcount(gtoy))

# Create data frame with IDs compatible to vertex names
df <- data.frame(ID=sample(V(gtoy)$name))

# Add two variables to 'df' for demonstration
df$var_mumbers <- rnorm(nrow(df))
df$var_letters <- letters[1:nrow(df)]

### Using the 'att.set' functions to transform edge and vertex attributes

# Map 'df' to vertex attributes
gtoy <- att.mapv(g = gtoy, dat = df, refcol = 1)

# Set a new vertex attribute, creating 'nodeLabel' from 'var_letters'
gtoy <- att.setv(gtoy, from = "var_letters", to = "nodeLabel")

# Set a new vertex attribute, creating 'nodeColor' from 'var_mumbers'
gtoy <- att.setv(gtoy,
    from = "var_mumbers", to = "nodeColor",
    breaks = seq(-1, 1, 0.2), pal = 2
)

# Set a new vertex attribute, creating 'nodeSize' from 'var_mumbers'
gtoy <- att.setv(gtoy,
    from = "var_mumbers", to = "nodeSize", nquant = 10,
    isrev = TRUE, xlim = c(5, 40, 1)
)

### Using the 'att.add' functions to add fixed values

# Add a new vertex attribute, creating 'nodeFontSize' from a fixed value
gtoy <- att.addv(gtoy, to = "nodeFontSize", value = 10)

# ...as above, but applied only to three nodes
gtoy <- att.addv(gtoy,
    to = "nodeFontSize", value = 100,
    filter = list("name" = V(gtoy)$name[1:3])
)

}
\seealso{
\code{\link{addGraphToRedeR}}, \code{\link{getGraphFromRedeR}}
}
