% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factors.R
\name{plotStability}
\alias{plotStability}
\title{Plot component stability as a function of the number of components}
\usage{
plotStability(
  stability,
  plot_path = NULL,
  stability_threshold = NULL,
  mean_stability_threshold = NULL,
  height = 4,
  width = 10,
  ...
)
}
\arguments{
\item{stability}{The results of \link[ReducedExperiment]{estimateStability}.}

\item{plot_path}{The path at which the plot will be saved}

\item{stability_threshold}{Plots a stability threshold, below which
components can be pruned by \link[ReducedExperiment]{runICA}.}

\item{mean_stability_threshold}{Plots a stability threshold, which is used
by \link[ReducedExperiment]{estimateStability} to provide a naive estimate
for the optimal number of components.}

\item{height}{The height of the plot, to be passed to \link[ggplot2]{ggsave}.}

\item{width}{The width of the plot, to be passed to \link[ggplot2]{ggsave}.}

\item{...}{Additional arguments to be passed to \link[ggplot2]{ggsave}.}
}
\value{
Returns a list of three plots as \code{ggplot2} objects:
\describe{
\item{combined_plot}{The two other plots combined with patchwork.}
\item{stability_plot}{A plot in which each line indicates stability
as a function of the number of components. A line is shown for each
number of components tested.}
\item{mean_plot}{The average component stability as a function of the
number of components.}
}
}
\description{
Plots the results of \link[ReducedExperiment]{estimateStability}. See this
function's documentation for more information.
}
\examples{
# Get a random matrix with rnorm, with 200 rows (features)
# and 100 columns (observations)
X <- ReducedExperiment:::.makeRandomData(200, 100, "feature", "obs")

# Estimate stability across 10 to 30 components
stab_res <- estimateStability(
    X,
    min_components = 10,
    max_components = 30,
    n_runs = 5,
    verbose = FALSE
)

# Intracluster stability similar to extracluster since this is random data
plotStability(stab_res)$combined_plot

}
\author{
Jack Gisby
}
