% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-FactorisedExperiment.R
\name{projectData}
\alias{projectData}
\alias{projectData,FactorisedExperiment,matrix-method}
\alias{projectData,FactorisedExperiment,data.frame-method}
\alias{projectData,FactorisedExperiment,SummarizedExperiment-method}
\alias{predict,FactorisedExperiment-method}
\title{Project new data using pre-defined factors}
\usage{
\S4method{projectData}{FactorisedExperiment,matrix}(
  object,
  newdata,
  standardise_reduced = TRUE,
  scale_newdata = NULL,
  center_newdata = NULL
)

\S4method{projectData}{FactorisedExperiment,data.frame}(
  object,
  newdata,
  standardise_reduced = TRUE,
  scale_newdata = NULL,
  center_newdata = NULL
)

\S4method{projectData}{FactorisedExperiment,SummarizedExperiment}(
  object,
  newdata,
  standardise_reduced = TRUE,
  scale_newdata = NULL,
  center_newdata = NULL,
  assay_name = "normal"
)

\S4method{predict}{FactorisedExperiment}(object, newdata, ...)
}
\arguments{
\item{object}{A \link[ReducedExperiment]{FactorisedExperiment} object. The
\code{loadings} slot of this class will be used for projection. Additionally, by
default, the \code{scale} and \code{center} slots are used to apply the original
transformation to the new data.}

\item{newdata}{New data for projection. Must be a \code{data.frame} or \code{matrix}
with features as rows and samples as columns, or a
\link[SummarizedExperiment]{SummarizedExperiment} object. Assumes that the
rows of \code{newdata} match those of the
\link[ReducedExperiment]{FactorisedExperiment} object.}

\item{standardise_reduced}{Whether or not the reduced data should be standardised
(i.e., transformed to have a mean of 0 and standard deviation of 1)
after calculation.}

\item{scale_newdata}{Controls whether the \code{newdata} are scaled. If \code{NULL},
performs scaling based on the \code{FactorisedExperiment}
object's \code{scale} slot. The value of this argument will be passed to the
\code{scale} argument of \link[base]{scale}.}

\item{center_newdata}{Controls whether the \code{newdata} are centered If \code{NULL},
performs centering based on the
\code{FactorisedExperiment} object's \code{center} slot. The
value of this argument will be passed to the \code{center} argument of
\link[base]{scale}.}

\item{assay_name}{If a \link[SummarizedExperiment]{SummarizedExperiment}
object is passed as new data, this argument indicates which assay should be
used for projection.}

\item{...}{Additional arguments to be passed to \code{projectData.}}
}
\value{
Calculates a matrix with samples as rows and factors as columns. If
\code{newdata} was a \code{matrix} or \code{data.frame}, this will be returned as a
\code{matrix}.
If a \link[SummarizedExperiment]{SummarizedExperiment} object was passed
instead, then a \code{FactorisedExperiment}
object will be created containing this \code{matrix} in its \code{reduced} slot.
}
\description{
Uses a projection approach to calculate factors in new data. Functions in a
similar fashion to the \code{predict} method of \link[stats]{prcomp}. The
transposed \code{newdata} are multiplied by the original loadings matrix.
}
\details{
If \code{scale_newdata} and \code{center_newdata} are left as \code{NULL}, then the
projection method assumes that the \code{newdata} are on the same scale as the
original data of the \code{object}. It will therefore use the values of the
\code{center} and \code{scale} slots of the \code{object}. For instance, if the \code{scale} slot
is \code{TRUE}, the \code{newdata} will be scaled. If the \code{scale} slot is a vector,
the values of this vector will be applied to scale the \code{newdata}.
}
\examples{
# Get two random matrices with rnorm
# 1: 100 rows (features) and 20 columns (observations)
X_1 <- ReducedExperiment:::.makeRandomData(100, 20, "feature", "obs")

# Both matrices must have the same features, but they may have different obs
# 2: 100 rows (features) and 30 columns (observations)
X_2 <- ReducedExperiment:::.makeRandomData(100, 30, "feature", "obs")

# Estimate 5 factors based on the data matrix
fe_1 <- estimateFactors(X_1, nc = 5)
fe_1

# Project the fe_1 factors for the samples in X_2
projected_data <- projectData(fe_1, X_2)
projected_data

}
\seealso{
\code{\link[ReducedExperiment]{calcEigengenes}}, \link[stats:prcomp]{stats::prcomp}
}
\author{
Jack Gisby
}
