% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lolaUtils.R
\name{getTargetFromLolaDb}
\alias{getTargetFromLolaDb}
\title{getTargetFromLolaDb}
\usage{
getTargetFromLolaDb(lolaDb)
}
\arguments{
\item{lolaDb}{LOLA DB object as returned by \code{LOLA::loadRegionDB} or \code{\link{loadLolaDbs}}}
}
\value{
character vector with targets
}
\description{
retrieve or guess the target from a LOLA DB object. Here, target typically
refers to antibodies for ChIP-seq experiments, but could also refer to other annotations
(e.g. motifs in TF motif databases, annotation according to UCSC features etc.)
}
\examples{
\donttest{
# download LOLA DB
lolaDest <- tempfile()
dir.create(lolaDest)
lolaDirs <- downloadLolaDbs(lolaDest, dbs="LOLACore")
lolaDb <- loadLolaDbs(lolaDirs[["hg19"]])
getTargetFromLolaDb(lolaDb)
}
}
\author{
Fabian Mueller
}
