% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialVariability.R
\name{rnb.execute.diffVar}
\alias{rnb.execute.diffVar}
\title{rnb.execute.diffVar}
\usage{
rnb.execute.diffVar(
  rnb.set,
  pheno.cols = rnb.getOption("differential.comparison.columns"),
  region.types = rnb.region.types.for.analysis(rnb.set),
  columns.adj = rnb.getOption("covariate.adjustment.columns"),
  adjust.celltype = rnb.getOption("differential.adjustment.celltype"),
  disk.dump = rnb.getOption("disk.dump.big.matrices"),
  disk.dump.dir = tempfile(pattern = "diffMethTables_")
)
}
\arguments{
\item{rnb.set}{Object of type \code{\linkS4class{RnBSet}} on which differential variability analysis should be conducted}

\item{pheno.cols}{Column names used to define the classes, whose methylation variability should be compared with each other}

\item{region.types}{Regions types to be used for the analysis. Defaults to the results given by rnb.region.types.for.analysis of the given RnBSet.}

\item{columns.adj}{Column names or indices in the table of phenotypic information to be used for confounder adjustment in the differential variability analysis.}

\item{adjust.celltype}{Flag indicating whether the resulting table should also contain estimated celltype contributions. See \code{\link{rnb.execute.ct.estimation}} for details.}

\item{disk.dump}{Flag indicating whether the resulting differential methylation object should be file backed, ie.e the matrices dumped to disk}

\item{disk.dump.dir}{disk location for file backing of the resulting differential methylation object. Only meaningful if \code{disk.dump=TRUE}.}
}
\value{
Object of type \code{\linkS4class{RnBDiffMeth}} containing information about the differential variability analysis.
}
\description{
This routine computes sites that are differentially variable between two sample groups specified as the column name 
in the phenotypic table.
}
\author{
Michael Scherer
}
