% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlPlots.R
\name{rnb.plot.control.boxplot}
\alias{rnb.plot.control.boxplot}
\title{rnb.plot.control.boxplot}
\usage{
rnb.plot.control.boxplot(
  rnb.set,
  type = rnb.infinium.control.targets(rnb.set@target)[1],
  writeToFile = FALSE,
  numeric.names = FALSE,
  ...
)
}
\arguments{
\item{rnb.set}{\code{\linkS4class{RnBeadRawSet}} or \code{\linkS4class{RnBeadSet}} object with valid quality
control information.}

\item{type}{type of the control probe; must be one of the \code{"BISULFITE CONVERSION I"},
\code{"BISULFITE CONVERSION II"}, \code{"EXTENSION"}, \code{"HYBRIDIZATION"}, \code{"NEGATIVE"},
\code{"NON-POLYMORPHIC"}, \code{"NORM_A"}, \code{"NORM_C"}, \code{"NORM_G"}, \code{"NORM_T"},
\code{"SPECIFICITY I"}, \code{"SPECIFICITY II"}, \code{"STAINING"}, \code{"TARGET REMOVAL"}.}

\item{writeToFile}{flag specifying whether the output should be saved as \code{\linkS4class{ReportPlot}}}

\item{numeric.names}{if \code{TRUE} and \code{writeToFile} is \code{TRUE}substitute the plot options in the plot file name with digits}

\item{...}{other arguments to \code{\link{createReportPlot}}}
}
\value{
plot as an object of type \code{\linkS4class{ReportPlot}} if \code{writeToFile} is \code{TRUE} and of class
			\code{\link{ggplot}} otherwise.
}
\description{
Box plots of various control probes
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.plot.control.boxplot(rnb.set.example)
}

}
\author{
Pavlo Lutsik
}
