% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlPlots.R
\name{rnb.plot.negative.boxplot}
\alias{rnb.plot.negative.boxplot}
\title{rnb.plot.negative.boxplot}
\usage{
rnb.plot.negative.boxplot(
  rnb.set,
  sample.subset = 1:length(samples(rnb.set)),
  writeToFile = FALSE,
  name.prefix = NULL,
  ...
)
}
\arguments{
\item{rnb.set}{\code{\linkS4class{RnBeadSet}} object with valid quality control information}

\item{sample.subset}{an integer vector specifying the subset of samples for which the plotting should be performed}

\item{writeToFile}{flag specifying whether the output should be saved as \code{\linkS4class{ReportPlot}}}

\item{name.prefix}{in case \code{writeToFile} is \code{TRUE}, a \code{character} singleton specifying a prefix to the variable part of the image file names}

\item{...}{other arguments to \code{\link{createReportPlot}}}
}
\value{
plot as an object of type \code{\linkS4class{ReportPlot}} if \code{writeToFile} is \code{TRUE} and of class
			\code{\link{ggplot}} otherwise.
}
\description{
Box plots of negative control probes
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.plot.negative.boxplot(rnb.set.example)
}
}
\author{
Pavlo Lutsik
}
