% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionProfiles.R
\name{rnb.plot.region.site.density}
\alias{rnb.plot.region.site.density}
\title{rnb.plot.region.site.density}
\usage{
rnb.plot.region.site.density(rnb.set, region.type, extend.by = 0.33)
}
\arguments{
\item{rnb.set}{RnBSet object}

\item{region.type}{Region type for which the plot should be generated}

\item{extend.by}{A number between 0 and 1 specifying the percentage by which a region is
extended in order to capture methylation information before region start and after region end}
}
\value{
a ggplot2 object for plotting
        the plot shows the density of sites accross the specified region type for all regions of that
        type from 0 (region start) to 1 (region end). Sites in the flanking areas are
        also shown (coordinates <0 and >1).
}
\description{
Plots the density of sites accross the specified region type
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.plot.region.site.density(rnb.set.example,"genes")
}
}
\author{
Fabian Mueller
}
