% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcReport.R
\name{rqcReport}
\alias{rqcReport}
\title{Quality Control HTML Report}
\usage{
rqcReport(
  rqcResultSet,
  outdir = tempdir(),
  file = "rqc_report",
  keepMD = FALSE,
  templateFile = system.file("templates", package = "Rqc", "rqc_report.Rmd")
)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}

\item{outdir}{output directory path.  It is created a temporary directory by
default.}

\item{file}{output file name.}

\item{keepMD}{If true Rqc does not delete markdown file.  \code{\link{knit}}
function takes RMarkdown template file (within package) and generates a
temporary Markdown file. Next \code{\link{markdownToHTML}} function takes
this markdown file and creates final HTML file.}

\item{templateFile}{Path of Rmarkdown file as Rqc web report template.}
}
\value{
Report file path.
}
\description{
Generates an HTML report file.
}
\details{
Also creates a directory called "figure" in \code{outdir} path.
}
\examples{

options(device.ask.default = FALSE)
checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
reportFile <- rqcReport(rqcResultSet)
browseURL(reportFile)

}
\seealso{
\code{\link{rqc}}

\code{\link{rqcQA}}
}
\author{
Welliton Souza
}
