% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetByGroup.R
\name{subsetByGroup}
\alias{subsetByGroup}
\title{Subset RqcResultSet object by group name.}
\usage{
subsetByGroup(rqcResultSet, group)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}

\item{group}{Name of the group to subset}
}
\value{
list of \code{RqcResultSet} objects from only one group.
}
\description{
This function subsets RqcResultSet object function by group name.
}
\examples{

folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
files <- list.files(full.names=TRUE, path=folder)
rqcResultSet <- rqcQA(files, workers=1, group=c("a", "b"))
perFileInformation(subsetByGroup(rqcResultSet, "a"))

}
\author{
Welliton Souza
}
\keyword{qc}
