% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{toRRDNA}
\alias{toRRDNA}
\title{Title: Convert DNA sequences to Reduced Representation format}
\usage{
toRRDNA(dnas)
}
\arguments{
\item{dnas}{Vector of DNA sequences (character vector).}
}
\value{
Vector of DNA converted to reduced representation format 
(character vector).
}
\description{
This function receives a vector of strings (character vector) 
containing DNA sequences and returns a vector of strings containing 
codified DNA.
}
\note{
This function is used internally to compute top over-represented 
reads and to store in RqcResultSet objects (per file top reads).
}
\examples{
dna <- "ATCGNATCGTA"
dna.converted <- toRRDNA(dna)
nchar(dna)
nchar(dna.converted)
}
\seealso{
\code{\link{perFileTopReads}}
}
\author{
Welliton Souza
}
