% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\docType{methods}
\name{sc3_calc_biology}
\alias{sc3_calc_biology}
\alias{sc3_calc_biology.SingleCellExperiment}
\alias{sc3_calc_biology,}
\alias{sc3_calc_biology,SingleCellExperiment-method}
\alias{sc3_calc_biology,SingleCellExperiment-method}
\alias{sc3_calc_biology}
\title{Calculate DE genes, marker genes and cell outliers.}
\usage{
sc3_calc_biology.SingleCellExperiment(object, ks, regime)

\S4method{sc3_calc_biology}{SingleCellExperiment}(object, ks = NULL,
  regime = NULL)
}
\arguments{
\item{object}{an object of \code{SingleCellExperiment} class}

\item{ks}{a continuous range of integers - the number of clusters \code{k} to be used for SC3 clustering.
Can also be a single integer.}

\item{regime}{defines what biological analysis to perform. "marker" for
marker genes, "de" for differentiall expressed genes and "outl" for outlier
cells}
}
\value{
an object of \code{SingleCellExperiment} class
}
\description{
This function calculates differentially expressed (DE) genes, marker genes 
and cell outliers based on the consensus \code{SC3} clusterings.
}
\details{
DE genes are calculated using \code{\link{get_de_genes}}. Results of the DE 
analysis are saved as new columns in the 
\code{featureData} slot of the input \code{object}. The column names correspond 
to the adjusted \code{p-value}s of the genes and have the following format: 
\code{sc3_k_de_padj}, where \code{k} is the number of clusters.

Marker genes are calculated using \code{\link{get_marker_genes}}. 
Results of the marker gene analysis are saved as three new 
columns (for each \code{k}) to the 
\code{featureData} slot of the input \code{object}. The column names correspond 
to the \code{SC3} cluster labels, to the adjusted \code{p-value}s of the genes 
and to the area under the ROC curve
and have the following format: \code{sc3_k_markers_clusts}, 
\code{sc3_k_markers_padj} and \code{sc3_k_markers_auroc}, where \code{k} is 
the number of clusters.

Outlier cells are calculated using \code{\link{get_outl_cells}}. Results of the 
cell outlier analysis are saved as new columns in the 
\code{phenoData} slot of the input \code{object}. The column names correspond 
to the \code{log2(outlier_score)} and have the following format: 
\code{sc3_k_log2_outlier_score}, where \code{k} is the number of clusters.

Additionally, \code{biology} item is added to the \code{sc3} slot and is set to
\code{TRUE} indicating that the biological analysis of the dataset has been
performed.
}
