% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCFA.R
\name{SCFA}
\alias{SCFA}
\title{SCFA}
\usage{
SCFA(dataList, k = NULL, max.k = 5, ncores = 10L, seed = NULL)
}
\arguments{
\item{dataList}{List of data matrices. In each matrix, rows represent samples and columns represent genes/features.}

\item{k}{Number of clusters, leave as default for auto detection.}

\item{max.k}{Maximum number of cluster}

\item{ncores}{Number of processor cores to use.}

\item{seed}{Seed for reproducibility, you still need to use set.seed function for full reproducibility.}
}
\value{
A numeric vector containing cluster assignment for each sample.
}
\description{
The main function to perform subtyping. It takes a list of data matrices as the input and outputs the subtype for each patient
}
\examples{
#Load example data (GBM dataset)
data("GBM")
#List of one matrix (microRNA data)
dataList <- GBM$data
#Survival information
survival <- GBM$survival
library(survival)
#Generating subtyping result
set.seed(1)
subtype <- SCFA(dataList, seed = 1, ncores = 2L)
#Perform survival analysis on the result
coxFit <- coxph(Surv(time = Survival, event = Death) ~ as.factor(subtype), data = survival, ties="exact")
coxP <- round(summary(coxFit)$sctest[3],digits = 20)
print(coxP)
}
