% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getSGFeatureCounts}
\alias{getSGFeatureCounts}
\title{Compatible counts for splice graph features from BAM files}
\usage{
getSGFeatureCounts(sample_info, features, min_anchor = 1,
  counts_only = FALSE, verbose = FALSE, cores = 1)
}
\arguments{
\item{sample_info}{Data frame with sample information.
Required columns are \dQuote{sample_name}, \dQuote{file_bam},
\dQuote{paired_end}, \dQuote{read_length}, \dQuote{frag_length}
and \dQuote{lib_size}. Library information can be obtained with
function \code{getBamInfo}.}

\item{features}{\code{SGFeatures} object}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{counts_only}{Logical indicating only counts should be returned}

\item{verbose}{If \code{TRUE}, generate messages indicating progress}

\item{cores}{Number of cores available for parallel processing}
}
\value{
code{SGFeatureCounts} object, or integer matrix of counts
  if \code{counts_only = TRUE}
}
\description{
Compatible counts are obtained for each sample and combined into
an \code{SGFeatureCounts} object.
}
\examples{
path <- system.file("extdata", package = "SGSeq")
si$file_bam <- file.path(path, "bams", si$file_bam)
sgfc <- getSGFeatureCounts(si, sgf_pred)
}
\author{
Leonard Goldstein
}
