% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomRegMethModelSim.R
\name{binomRegMethModelSim}
\alias{binomRegMethModelSim}
\title{Simulate Bisulfite sequencing data from specified smooth covariate
effects}
\usage{
binomRegMethModelSim(
  n,
  posit,
  theta.0,
  beta,
  phi,
  random.eff = FALSE,
  mu.e = 0,
  sigma.ee = 1,
  p0 = 0.003,
  p1 = 0.9,
  X,
  Z,
  binom.link = "logit",
  verbose = TRUE
)
}
\arguments{
\item{n}{sample size}

\item{posit}{a numeric vector of size \code{p} (the number
of CpG sites in the considered region) containing the genomic positions;}

\item{theta.0}{numeric vector of size \code{p} which is a functional
parameter for the intercept of the GAMM model.}

\item{beta}{numeric vector of size \code{p} which is a functional parameter
for the slope of cell type composition.}

\item{phi}{a vector of length \code{p} determining the multiplicative
dispersion parameter for each loci in a region. The dispersed-Binomial
counts are simulated from beta-binomial distribution, so each element of phi
has to be greater than 1.}

\item{random.eff}{indicates whether adding the subject-specific random effect
term \code{e}.}

\item{mu.e}{number, the mean of the random effect.}

\item{sigma.ee}{positive number, variance of the random effect}

\item{p0}{the probability of observing a methylated read when the underlying
true status is unmethylated. \code{p0} is the rate of false methylation
calls, i.e. false positive rate.}

\item{p1}{the probability of observing a methylated read when the underlying
true status is methylated. \code{1-p1} is the rate of false non-methylation
calls, i.e. false negative rate.}

\item{X}{the matrix of the read coverage for each CpG in each sample; a
matrix of n rows and \code{p} columns.}

\item{Z}{numeric matrix with \code{p} columns and \code{n} rows storing the
covariate information.}

\item{binom.link}{the link function used for simulation}

\item{verbose}{logical indicates if the algorithm should provide progress
report information.
The default value is TRUE.}
}
\value{
The function returns a list of following objects
\itemize{
\item \code{S} a numeric matrix of \code{n} rows and \code{p} columns
containing the true methylation counts;
\item \code{Y} a numeric matrix of \code{n} rows and \code{p} columns
containing the observed methylation counts;
\item \code{theta} a numeric matrix of \code{n} rows and \code{p} columns
containing the methylation parameter (after the logit transformation);
\item \code{pi} a numeric matrix of \code{n} rows and \code{p} columns
containing the true methylation proportions used to simulate the data.
}
}
\description{
Simulate Bisulfite sequencing data from a Generalized Additive
Model with functional parameters varying with the genomic position. Both the
true methylated counts and observed methylated counts are generated, given
the error/conversion rate parameters \code{p0} and \code{p1}. In addition,
the true methylated counts can be simulated from a binomial or a dispersed
binomial distribution (Beta-binomial distribution).
}
\examples{
#------------------------------------------------------------#
data(RAdat)
RAdat.f <- na.omit(RAdat[RAdat$Total_Counts != 0, ])
out <- binomRegMethModel(
   data=RAdat.f, n.k=rep(5, 3), p0=0, p1=1,
   epsilon=10^(-6), epsilon.lambda=10^(-3), maxStep=200, RanEff = FALSE
)
Z = as.matrix(RAdat.f[match(unique(RAdat.f$ID), RAdat.f$ID),
c('T_cell', 'RA')])
set.seed(123)
X = matrix(sample(80, nrow(Z)*length(out$uni.pos), replace = TRUE),
nrow = nrow(Z), ncol = length(out$uni.pos))+10
simdat = binomRegMethModelSim(n=nrow(Z), posit= out$uni.pos,
theta.0=out$Beta.out[,1], beta= out$Beta.out[,-1], random.eff=FALSE,
mu.e=0,sigma.ee=1, p0=0.003, p1=0.9,X=X , Z=Z, binom.link='logit',
phi = rep(1, length(out$uni.pos)))
}
\author{
Kaiqiong Zhao
}
