% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_gradient.R
\name{compute_gradient}
\alias{compute_gradient}
\title{compute_gradient}
\usage{
compute_gradient(spe_object, radii, FUN, ...)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{radii}{Numeric Vector specifying the range of radii for the metrics to
be calculated.}

\item{FUN}{Variable name specifying the metric.}

\item{...}{Arguments of FUN}
}
\value{
A list of the metrics under all radii
}
\description{
The function sweeps over circles of a range of radii surrounding
  reference cells and calculates the metrics at the radii. Metrics used with
  function need two conditions: 1) have a `radius` parameter. 2) return a
  single number. For metrics that do not return a single number, users can
  wrap them in a new function that returns a number and then pass the new
  function to `compute_gradient()`.
}
\examples{
gradient_positions <- c(30, 50, 100)
gradient_entropy <- compute_gradient(SPIAT::defined_image, 
radii = gradient_positions, FUN = calculate_entropy,  
cell_types_of_interest = c("Immune1","Immune2"), 
feature_colname = "Cell.Type")
}
