% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_celltypes.R
\name{select_celltypes}
\alias{select_celltypes}
\title{select_celltypes}
\usage{
select_celltypes(
  spe_object,
  celltypes,
  feature_colname = "Phenotype",
  keep = TRUE
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{celltypes}{String Vector of celltypes of keep or exclude.}

\item{feature_colname}{String. The column that has the interested cell types.
If the cells ids are used to select cells, use "Cell.ID" for this arg.}

\item{keep}{Boolean. TRUE if vector of `celltypes` are the cells that are
going to be kept, FALSE if they are to be removed.}
}
\value{
A SpatialExperiment object is returned. The original image size
  and cell count can be accessed by `attr(slim_spe, "original_cell_number")`
  and `attr(slim_spe, "range_of_coords")`, where `slim_spe` is the output of
  this function.
}
\description{
Select cell types to keep or exclude in the analysis. The output
  of this function also includes the original image size and cell count.
}
\examples{
data_subset <- select_celltypes(SPIAT::simulated_image,
celltypes = c("Tumour_marker","Immune_marker1","Immune_marker2",
"Immune_marker3","Immune_marker4"),
feature_colname = "Phenotype", keep=TRUE)
attr(data_subset, "original_cell_number") #cell number in the original image
attr(data_subset, "range_of_coords")
dim(data_subset)[2] # this is the new image cell number
}
