% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_re_genes.R
\name{extract_gene_peak_annotations}
\alias{extract_gene_peak_annotations}
\title{Overlap peaks with gene promoters to obtain gene annotations}
\usage{
extract_gene_peak_annotations(
  peaks,
  txdb,
  annot_dbi,
  protein_coding_only = TRUE,
  upstream,
  downstream,
  verbose = FALSE
)
}
\arguments{
\item{peaks}{A \code{GRanges} or \code{data.frame} of peaks with at least the following columns:
\describe{
\item{seqnames}{Chromosome name of the regulatory region (e.g., \code{"chr1"}). Only for data.frames.}
\item{start}{Start coordinate of the peak. Only for data.frames.}
\item{end}{End coordinate of the peak. Only for data.frames.}
\item{region_id}{Unique identifier of the region (e.g., \code{chr1-5000-5800})}
}}

\item{txdb}{\code{TxDb} object for genome annotation (required if annotation requested).}

\item{annot_dbi}{\code{AnnotationDbi} object for gene ID mapping (required if annotation requested).}

\item{protein_coding_only}{Logical; restrict to protein-coding genes (default TRUE).}

\item{upstream}{Single integer value indicating the number of bases upstream
from the TSS (transcription start sites) (default \code{"2000kb"}).}

\item{downstream}{Single integer values indicating the number of bases downstream
from the TSS (transcription start sites) (default \code{"2000kb"}).}

\item{verbose}{Logical; print messages (default TRUE).}
}
\value{
A \code{GRanges with} with:
\describe{
\item{seqnames, start, end}{Coordinates of the peak that overlaps with a gene promoter.}
\item{region_id}{Unique identifier of the region (e.g., \code{chr1-5000-5800}).}
\item{gene_id}{Identifier of the gene. Must be an official gene symbol (e.g., \code{GAPDH})}
}
}
\description{
Identifies overlaps between a set of peaks and promoter regions,
optionally restricted to protein-coding genes.
}
