% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_splinter.R
\name{extractSpliceSites}
\alias{extractSpliceSites}
\title{extractSpliceSites}
\usage{
extractSpliceSites(
  df,
  target = "SE",
  site = "donor",
  motif_range = c(-3, 6),
  start0 = TRUE
)
}
\arguments{
\item{df}{extractSpliceEvents object}

\item{target}{the target site to extract. See Details.}

\item{site}{character donor or acceptor}

\item{motif_range}{numeric vector of splice position to extract}

\item{start0}{boolean 0-base start}
}
\value{
GRanges object
}
\description{
Extracts and formats to bed the location of target, upstream and downstream
splice sites
}
\details{
target : the site to extract the sequence from. It can be either the
         event in question (SE, RI, MXE - first exon, MXE2 - second exon,
         A5SSlong, A5SSshort, A3SSlong, A3SSshort, upstream or downstream).
         If this function is used in conjunction with \link{shapiroDonor} or
         \link{shapiroAcceptor} to compute scores, then most likely it will be run
         twice - once for the event, and the other either up- or downstream
         as a comparison.
}
\examples{
data_path<-system.file("extdata",package="SPLINTER")
splice_data<-extractSpliceEvents(data=paste(data_path,"/skipped_exons.txt",sep=""))
splice_sites<-extractSpliceSites(splice_data,target="SE")
}
\seealso{
\url{http://rnaseq-mats.sourceforge.net/user_guide.htm} for MATS file definition
}
\author{
Diana Low
}
