% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_splinter.R
\name{shapiroAcceptor}
\alias{shapiroAcceptor}
\title{shapiroAcceptor}
\usage{
shapiroAcceptor(reference_fasta, target_fasta)
}
\arguments{
\item{reference_fasta}{vector of strings or DNAStringSet of reference splice list}

\item{target_fasta}{vector of strings or DNAStringSet of fasta to score}
}
\value{
data.frame with Shapiro scores
}
\description{
Shapiro's score of acceptor site (range is from -13 [intron] to +1 [exon]) is:
100 * ((t1 - l1)/(h1 - l1) + (t2 - l2)/(h2 - l2))/2, where
t1 is the sum of the best 8 of 10 percentages at positions -13 to -4,
l1 is the sum of the lowest 8 of 10 percentages at position -13 to -4,
h1 is the sum of the highest 8 of 10 percentages at positions -13 to -4,
t2 is the sum of percentages at positions -3 to +1,
l2 is the sum of the lowest percentages at positions -3 to +1, and
h2 is the sum of the highest percentages at positions -3 to +1
}
\examples{
library(BSgenome.Mmusculus.UCSC.mm9)
bsgenome <- BSgenome.Mmusculus.UCSC.mm9
data_path<-system.file("extdata",package="SPLINTER")
splice_data<-extractSpliceEvents(data=paste(data_path,"/skipped_exons.txt",sep=""))
splice_sites<-extractSpliceSites(splice_data,site="acceptor")
acceptor.ss<-getSeq(bsgenome,splice_sites)
##sacceptor<-shapiroAcceptor(acceptor.m,acceptor.ss)
}
\seealso{
\url{http://www.softberry.com/spldb/SpliceDB.html}
}
\author{
Diana Low
}
