% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_subsampling.R
\name{sponge_subsampling}
\alias{sponge_subsampling}
\title{Sponge subsampling}
\usage{
sponge_subsampling(
  subsample.n = 100,
  subsample.repeats = 10,
  subsample.with.replacement = FALSE,
  subsample.plot = FALSE,
  gene_expr,
  mir_expr,
  ...
)
}
\arguments{
\item{subsample.n}{the number of samples to be drawn in each round}

\item{subsample.repeats}{how often should the subsampling be done?}

\item{subsample.with.replacement}{logical, should we allow samples to be used
repeatedly}

\item{subsample.plot}{logical, should the results be plotted as box plots}

\item{gene_expr}{A gene expression matrix with samples in rows and featurs
in columns. Alternatively an object of class ExpressionSet.}

\item{mir_expr}{A miRNA expression matrix with samples in rows and features
in columns. Alternatively an object of class ExpressionSet.}

\item{...}{parameters passed on to the sponge function}
}
\value{
a summary of the results with mean and standard deviations of the
correlation and sensitive correlation.
}
\description{
Sponge subsampling
}
\examples{
sponge_subsampling(gene_expr = gene_expr,
mir_expr = mir_expr, mir_interactions = mir_interactions,
subsample.n = 10, subsample.repeats = 1)
}
\references{
sponge
}
