% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-encode.R
\name{runENCODE}
\alias{runENCODE}
\alias{runENCODE,SingleCellExperiment-method}
\alias{runENCODE,SingleCellExperiment}
\title{One hot encode for the specified cell category.}
\usage{
runENCODE(data, group.by, rm.group.nm = NULL, ...)

\S4method{runENCODE}{SingleCellExperiment}(data, group.by, rm.group.nm = NULL, ...)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object, or a \linkS4class{SVPExperiment} object with specified
\code{gsvaexp} argument.}

\item{group.by}{character a specified category column names (for example the cluster column name) of
\code{colData(data)}. Or a vector of length equal to ‘ncol(data)’, specifying the group to which each cell
is assigned. It is required.}

\item{rm.group.nm}{character which want to remove some group type names from the names of
the specified category group, default is NULL.}

\item{...}{currently meaningless.}
}
\value{
SVPExperiment object
}
\description{
This function convert the specified cell category to one hot encode
}
\examples{
data(sceSubPbmc)
sceSubPbmc
sceSubPbmc <- runENCODE(sceSubPbmc, group.by = 'seurat_annotations') 
sceSubPbmc
gsvaExp(sceSubPbmc, 'seurat_annotations')
sceSubPbmc <- runENCODE(sceSubPbmc, group.by = 'seurat_annotations', rm.group.nm = c('Platelet'))
sceSubPbmc
gsvaExp(sceSubPbmc, 'seurat_annotations')
# The group.by also can be a vector of length equal to ncol(data).
sceSubPbmc <- runENCODE(
                sceSubPbmc, 
                group.by = sceSubPbmc$seurat_annotations, 
                rm.group.nm = c('Platelet')
              )
sceSubPbmc
identical(gsvaExp(sceSubPbmc, 'seurat_annotations'), gsvaExp(sceSubPbmc, "ENCODE"))
}
