% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4.R
\docType{class}
\name{SeqSQC-class}
\alias{SeqSQC-class}
\alias{SeqSQC}
\alias{gdsfile}
\alias{gdsfile<-}
\alias{QCresult}
\alias{QCresult<-}
\alias{gdsfile,SeqSQC-method}
\alias{gdsfile<-,SeqSQC-method}
\alias{"gdsfile<-",SeqSQC-method}
\alias{QCresult,SeqSQC-method}
\alias{QCresult<-,SeqSQC-method}
\alias{"QCresult<-",SeqSQC-method}
\title{A data format to store genotype phenotype and sample QC results from SeqSQC.}
\usage{
SeqSQC(gdsfile, QCresult = List())

gdsfile(x)

gdsfile(x) <- value

QCresult(x)

QCresult(x) <- value

\S4method{gdsfile}{SeqSQC}(x)

\S4method{gdsfile}{SeqSQC}(x) <- value

\S4method{QCresult}{SeqSQC}(x)

\S4method{QCresult}{SeqSQC}(x) <- value
}
\arguments{
\item{gdsfile}{A character string for the filepath of the GDS file.}

\item{QCresult}{A list with sample information and sample QC results.}

\item{x}{an SeqSQCClass object.}

\item{value}{the new value for the SeqSQC object slots.}
}
\value{
The filepath to the gds file.
}
\description{
A SeqSQC object is a list of two objects. The first object
\code{gdsfile} is the filepath of the GDS (discussed in section
below) file which stores the genotype information from the original
VCF file. The second object \code{QCresult} is a list of sample
information and QC results, which include the dimension (# of
samples and variants), sample annotation, and QC results for sample
missing rate, sex check, inbreeding outlier check, IBD check, and
population outlier check.
}
\section{Slots}{

\describe{
\item{\code{gdsfile}}{A character string for the filepath of the GDS file.}

\item{\code{QCresult}}{A list with sample information and sample QC results.}
}}

\examples{
load(system.file("extdata", "example.seqfile.Rdata", package="SeqSQC"))
gdsfile(seqfile)
QCresult(seqfile)
}
