% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mut_catalogues.R
\name{create_mut_catalogues}
\alias{create_mut_catalogues}
\title{Creates simulated mutational catalogues}
\usage{
create_mut_catalogues(n, m, P = get(utils::data("cosmicSigs", package =
  "SigsPack")), sig_set = NULL, c_exposure = NULL)
}
\arguments{
\item{n}{Amount of mutational catalogues that will be created}

\item{m}{Amount of mutations that each catalogues will have}

\item{P}{Matrix (f x k) containing the signature profiles of k signatures
which will be used to create the catalogues
k is the amount of signature profiles that P contains
f is the amount of features that the profiles are defined on
(default: COSMIC signature matrix 96 x 30) (optional)}

\item{sig_set}{Numeric vector containing the index of the columns from P
(which are the signature profiles) that will be used to create the catalogues
(optional). Defaults to all columns of P.}

\item{c_exposure}{Numeric vector specifying the contribution of each 
signature to the distribution each sample is drawn from. Samples will have an
appr. exposure of c_exposure[idx] to signature sig_set[idx] 
(if sum(c_exposure)==1). (optional)
Default: random exposure.}
}
\value{
List containing a matrix (f x n) with the simulated catalogues and a
matrix (k x n) detailing the signature exposure of each catalogue
}
\description{
Creates mutational catalogues from chosen mutational signature profiles to
gain simualted data sampled from a distirbution with with known signature
contribution
}
\examples{
data(cosmicSigs)
sim_data <- create_mut_catalogues(10, 300, cosmicSigs, c(2,6,15,27))
sim_data <- create_mut_catalogues(1000, 500)
sim_data <- create_mut_catalogues(1, 500, sig_set = c(1,4,29), c_exposure = c(0.25, 0.65, 0.1))

}
