% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleCellAlleleExperiment.R
\name{genes2functional}
\alias{genes2functional}
\title{Building second new subassay for the SingleCellAlleleExperiment object}
\usage{
genes2functional(sce, lookup, exp_type, gene_symbols)
}
\arguments{
\item{sce}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object.}

\item{lookup}{A data.frame object containing the lookup table.}

\item{exp_type}{Internal character string parameter that determines in which
format the gene symbols in the input data are. Can be \code{c("ENS","noENS")}}

\item{gene_symbols}{A logical parameter to decide whether to compute additional
gene gene symbols in case the raw data only contains ENSEMBL gene identifiers.}
}
\value{
A SingleCellExperiment object
}
\description{
Internal function for the second assay extension used in the
\code{SingleCellAlleleExperiment()} constructor, computing the second of the two
new subassays that get appended to the quantification assay. This subassay
contains the functional allele classes and sums up the expression counts of
the allele genes that are in the same functional group.
}
