% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{SpaNormFit}
\alias{SpaNormFit}
\alias{SpaNormFit-class}
\alias{$,SpaNormFit-method}
\title{An S4 class to store a SpaNorm model fit}
\usage{
\S4method{$}{SpaNormFit}(x, name)
}
\arguments{
\item{x}{an object of class SpaNormFit.}

\item{name}{a character, specifying the name of the slot to retrieve.}
}
\value{
Return value varies depending on method.
}
\description{
An S4 class to store a SpaNorm model fit
}
\section{Slots}{

\describe{
\item{\code{ngenes}}{a numeric, specifying the number of genes in the dataset.}

\item{\code{ncells}}{a numeric, specifying the number of cells/spots in the dataset.}

\item{\code{gene.model}}{a character, specifying the gene-specific model to used (see \code{getGeneModels()}).}

\item{\code{df.tps}}{an integer, specifying the degrees of freedom to used for the thin plate spline.}

\item{\code{sample.p}}{a numeric, specifying the proportion of samples used to approximated the model.}

\item{\code{lambda.a}}{a numeric, specifying the shinkage parameter used.}

\item{\code{batch}}{a vector or matrix, specifying the batch design used (if any).}

\item{\code{W}}{a matrix, specifying the covariate matrix of the linear model.}

\item{\code{alpha}}{a matrix, specifying the coefficients of the linear model.}

\item{\code{gmean}}{a numeric, specifying the mean estimate for each gene in the linear model.}

\item{\code{psi}}{a numeric, specifying the over-dispersion parameter for each gene if a negative binomial model was used (or a vector of NAs if another gene model is used).}

\item{\code{wtype}}{a factor, specifying the covariate types of columns in the covariate matrix, W. These could be "biology", "ls", or "batch".}

\item{\code{loglik}}{a numeric, specifying the log-likelihood of the model at each external iteration.}
}}

\examples{
example(SpaNorm)
}
