% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdutils.R
\name{calculate_gene_scores_directed}
\alias{calculate_gene_scores_directed}
\title{Calculate interaction scores for all pattern pairs}
\usage{
calculate_gene_scores_directed(
  data,
  pat_hotspots,
  influence_hotspots,
  pattern_pairs = NULL,
  ...
)
}
\arguments{
\item{data}{A numeric matrix with genes as rows and barcodes as columns.}

\item{pat_hotspots}{A data frame with pattern hotspots, containing columns for x, y, and barcode.}

\item{influence_hotspots}{A data frame with influence hotspots, containing columns for x, y, and barcode.}

\item{pattern_pairs}{A data frame with pattern pairs to calculate interaction scores for. If NULL,
all combinations of patterns in \code{pat_hotspots} will be used.
If provided, it should have two columns with pattern names.
Each row should represent a pair of patterns for which interaction scores will be calculated.}

\item{...}{Additional parameters to pass to lower level functions.}
}
\value{
A data frame with interaction scores for all pattern pairs.
}
\description{
This function calculates interaction scores for all pattern pairs
using the \code{.calc_IM_scores} function. It can run in parallel if BiocParallel is available.
}
