% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_spatial_data_over_image}
\alias{plot_spatial_data_over_image}
\title{plotSpatialDataOverImage}
\usage{
plot_spatial_data_over_image(
  visiumDir,
  df,
  feature_col,
  barcode_col = "barcode",
  resolution = c("lowres", "hires", "fullres"),
  version = NULL,
  colors = NULL,
  point_size = 2.5,
  stroke = 0.05,
  alpha = 0.5,
  title = "Spatial Heatmap",
  bg_color = NULL,
  crop = TRUE,
  text_size = 15
)
}
\arguments{
\item{visiumDir}{directory with a spatial folder containing
scalefactors_json.json, images (lowres,or hires), and
coordinates (tissue_positons_(list).csv or probe.csv)}

\item{df}{a dataframe with the features of interest. For example,
can behotspots (character), and/or influence (numeric))}

\item{feature_col}{feature to plot over spots, Default: NULL}

\item{barcode_col}{barcode column name to match with coordinates,
Default: 'barcode'}

\item{resolution}{Image resoultion to scale coordinates too,
Default: c("lowres", "hires", "fullres")}

\item{version}{Visium version. Automatically infers from load10XCoords if
NULL,Default: NULL}

\item{colors}{colors to be displayed over spots. If set to NULL, it
automatically colors the spots red for character values and uses viridis for
numeric values. Default: NULL}

\item{point_size}{size of spots displayed on the plot, Default: 2.5}

\item{stroke}{thickness of spot outline, Default: 0.05}

\item{alpha}{Transparency of the spots, Default: 0.5}

\item{title}{Title displayed on the plot, Default: 'Spatial Heatmap'}

\item{bg_color}{background color of ggplot box, Default: NULL}

\item{crop}{crop spatial plot to a zoomed in window, Default: TRUE}

\item{text_size}{size of text on the plot, Default: 15}
}
\value{
a ggplot object
}
\description{
This function plots spatial data over the complementary
histology image of varing resolutions
}
