% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readVisiumHD}
\alias{readVisiumHD}
\title{Read Visium HD data}
\usage{
readVisiumHD(
  data_dir,
  bin_size = c(2L, 8L, 16L),
  sample_id = NULL,
  type = c("HDF5", "sparse"),
  data = c("filtered", "raw"),
  images = c("lowres", "hires"),
  unit = c("full_res_image_pixel", "micron"),
  style = "W",
  zero.policy = NULL,
  row.names = c("id", "symbol"),
  flip = c("geometry", "image"),
  add_graph = FALSE,
  rotate = FALSE
)
}
\arguments{
\item{data_dir}{Directory}

\item{bin_size}{One or more resolutions to load, must be 2, 8, or 16. Can be
either integer or character.}

\item{sample_id}{Which sample(s) in the SFE object to use for the graph. Can
also be "all", which means this function will compute the graph for all
samples independently.}

\item{type}{Either "HDF5", and the matrix will be represented as
\code{TENxMatrix}, or "sparse", and the matrix will be read as a
\code{dgCMatrix}.}

\item{data}{character string specifying whether to read in
filtered (spots mapped to tissue) or raw data (all spots).}

\item{images}{character vector specifying which images to include. 
Valid values are \code{"lowres", "hires", "fullres", "detected", "aligned"}}

\item{unit}{Whether to use pixels in full resolution image or microns as the
unit. If using microns, then spacing between spots in pixels will be used
to convert the coordinates into microns, as the spacing is known to be 100
microns. This is used to plot scale bar.}

\item{style}{\code{style} can take values \dQuote{W}, \dQuote{B}, \dQuote{C}, \dQuote{U}, \dQuote{minmax} and \dQuote{S}}

\item{zero.policy}{default NULL, use global option value; if FALSE stop with error for any empty neighbour sets, if TRUE permit the weights list to be formed with zero-length weights vectors}

\item{row.names}{String specifying whether to use Ensembl IDs ("ID") or gene symbols ("Symbol") as row names. 
For symbols, the Ensembl ID will be appended to disambiguate rows where the same symbol corresponds to multiple Ensembl IDs.}

\item{flip}{Whether to flip the geometries or the images, because in
\code{sf} and \code{terra}, the geometries use the Cartesian coordinates
greater y coordinates going up, while in images, greater y values go down.
Originally the Visium spots are in pixels in full res image. Either the
image or the geometry needs to be flipped for them match in the Cartesian
coordinate system.}

\item{add_graph}{\code{c(local)}, if to add spatial neighborhood graph for
spots and only if \code{c(data = "filtered")}. Default is \code{c(TRUE)}.
This is optional because for larger datasets, the graph can take a while to
compute.}

\item{rotate}{Logical, whether to rotate the geometry, because usually the
grid of spots is slightly, but just very slightly, rotated from the perfect
horizontal line. The spots can be rotated so the square polygons are more
accurate, because for computational efficiency, \code{st_buffer} is used to
create the polygons which are not rotated. This is optional because the
rotation is very slight.}
}
\value{
An SFE object if `length(bin_size) == 1L`, otherwise a list of SFE
  objects each element of which is for one bin size. They're not concatenated
  since it might not make sense to perform joint analyses on the different
  resolutions that benefit from having them in the same SFE object, unlike
  different biological replica. Here unlike in
  \code{\link{read10xVisiumSFE}}, the centroids geometry is also added
  because it will greatly facilitate plotting when there are many spots when
  not zooming in. See the \code{scattermore} argument in
  \code{\link[Voyager]{plotSpatialFeature}}.
}
\description{
This function reads Visium HD Space Ranger output into R.
}
\examples{
#
}
